VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmSelect 
   Caption         =   "wirt"
   ClientHeight    =   7020
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   7905
   OleObjectBlob   =   "frmSelect.frx":0000
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "frmSelect"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

' Copyright (C) 2007 Stephane Germain <stephane.germain@gmail.com>
'
' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or (at
' your option) any later version.
'
' This program is distributed in the hope that it will be useful, but
' WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
' General Public License for more details.
'
' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

Option Explicit
Option Base 0

Public resetSelection As Boolean

Public Sub ComputeSelectionSize()
    If refSelection.Value <> "" Then
        NbrSubject = Range(refSelection.Value).Rows.Count
        NbrItem = Range(refSelection.Value).Columns.Count
        If chkSubjectLabel.Value Then NbrItem = NbrItem - 1
        If chkItemLabel.Value Then NbrSubject = NbrSubject - 1
        If chkKey.Value Then NbrSubject = NbrSubject - 1
    End If
End Sub

Public Sub UpdateLinesNumbers()
    If chkItemLabel.Value Then
        chkKey.Caption = GText("chkkey", GText("chkKeySecond"))
    Else
        chkKey.Caption = GText("chkkey", GText("chkKeyFirst"))
    End If
End Sub

Private Sub btnCancel_Click()
    Me.Hide
End Sub

Private Sub btnHelp_Click()
    WirtHelp
End Sub

Private Sub btnNext_Click()
    On Error GoTo errorEnd
    
    Dim i As Integer
    Dim ColOffset As Integer ' the first data line - 1
    Dim RowOffset As Integer ' the first data column - 1
    Dim KeyPos As Integer
    Dim rngSelection As Range
    
    ComputeSelectionSize
    Set rngSelection = Range(refSelection.Value)
    ColOffset = 0
    RowOffset = 0
    If chkSubjectLabel.Value Then ColOffset = ColOffset + 1
    If chkItemLabel.Value Then RowOffset = RowOffset + 1
    If chkKey.Value Then
        RowOffset = RowOffset + 1
        KeyPos = RowOffset
    End If
    
    ' validate the selection size
    If NbrItem < 2 Or NbrSubject < 2 Then
        MsgBox GText("msgSelectionTooSmall"), vbApplicationModal, ProgName
        GoTo retryEnd
    End If
    
    Set RawData = rngSelection.Offset(RowOffset, ColOffset).Resize(NbrSubject, NbrItem)
    
    ' allocate the memory for the selection
    ReDim SubjectLabels(NbrSubject) As String
    ReDim ItemLabels(NbrItem) As String
    ReDim Key(NbrItem) As String
    
    ' create the subject label
    If chkSubjectLabel.Value Then
        For i = 1 To NbrSubject
            SubjectLabels(i) = CStr(rngSelection(RowOffset + i, 1))
        Next i
    Else
        For i = 1 To NbrSubject
            SubjectLabels(i) = GText("lblSubject", i)
        Next i
    End If
    
    ' create the item label
    If chkItemLabel.Value Then
        For i = 1 To NbrItem
            ItemLabels(i) = CStr(rngSelection(1, ColOffset + i))
        Next i
    Else
        For i = 1 To NbrItem
            ItemLabels(i) = GText("lblitem", i)
        Next i
    End If
    
    ' create the key
    If chkKey.Value Then
        For i = 1 To NbrItem
            Key(i) = CStr(rngSelection(KeyPos, ColOffset + i))
        Next i
        HaveKey = True
    Else
        HaveKey = False
    End If
    
normalEnd:
    On Error GoTo 0
    Me.Hide
    StepNum = StepNum + 1
    frmData.Show
    
retryEnd:
    Exit Sub

errorEnd:
    MsgBox GText("msgError", Err.Description), vbCritical, ProgName
End Sub

Private Sub chkItemLabel_Click()
    UpdateLinesNumbers
End Sub

Private Sub chkKey_Click()
    UpdateLinesNumbers
End Sub

Private Sub UserForm_Activate()
    ReadSetting
    Me.Caption = ProgName
    ' get the localized string
    btnBack.Caption = GText("btnBack")
    btnNext.Caption = GText("btnNext")
    btnHelp.Caption = GText("btnHelp")
    btnCancel.Caption = GText("btnCancel")
    lblStep.Caption = GText("lblStep", StepNum, NbrStep)
    lblInstruction.Caption = GText("lblInstructionSelection")
    lblSelection.Caption = GText("lblSelection")
    chkSubjectLabel.Caption = GText("chkSubjectLabel")
    chkItemLabel.Caption = GText("chkItemLabel")
    chkKey.Caption = GText("chkKey", GText("chkKeyFirst"))
    chkSubjectLabel.ControlTipText = GText("ttchkSubjectLabel")
    chkItemLabel.ControlTipText = GText("ttchkItemLabel")
    chkKey.ControlTipText = GText("ttchkKey")
    refSelection.ControlTipText = GText("ttRefSelection")
    
    If resetSelection And TypeName(Selection) = "Range" Then
        refSelection.Value = Selection.Address
        resetSelection = False
    End If
    refSelection.SetFocus
End Sub

Private Sub UserForm_Initialize()
    resetSelection = True
End Sub

