nbr.subject <- 5000
nbr.item <- 10
nbr.simul <- 1
nbr.option <- 4
code <- c("A", "B", "C", "D", "E", "F")
for(i in 1:nbr.simul){
  abilities <- rnorm(nbr.subject)
  a <- t(sapply(1:nbr.item, function(j)runif(nbr.option, -1.5, 1.5)))
  b <- t(sapply(1:nbr.item, function(j)runif(nbr.option, -2, 2)))
  ab <- a*b
  a.mean <- apply(a, 1, mean)
  ab.mean <- apply(ab, 1, mean)
  a <- a - a.mean
  ab <- ab - ab.mean
  b <- ab/a
  key <- max.col(a)
  responses <- sapply(1:nbr.item, function(j) {
    sapply(abilities, function(abil) {
      p <- exp(a[j,]*(abil-b[j,]))
      p <- p/sum(p)
      p.cum <- cumsum(p)
      length(p.cum[runif(1)>p.cum])+1
    })
  })
  responses.and.key <- rbind(key, responses)
  responses.and.key <- apply(responses.and.key,2,function(x)code[x])
  write.csv(list(key=key),sprintf("E:/Nominal_key%02d.csv",i))
  write.csv(list(ability=abilities),sprintf("E:/Nominal_abilities%02d.csv",i))
  write.csv(list(option=rep(1:nbr.option,nbr.item),slope=as.vector(t(a)),
      threshold=as.vector(t(b))),
    sprintf("E:/Nominal_items%02d.csv",i), row.names=as.character(rep(1:nbr.item,each=nbr.option)))
  write.csv(responses.and.key,sprintf("E:/Nominal_responses_and_key%02d.csv",i),
    row.names=c("key",as.character(1:nbr.subject)))
}
